/*****************************************************************************
*                           Freescale Semiconductor                          *
*                                                                            *
*  Project    : AN3815 - MC56F8006 Modular Pixel Matrix                      *
*  Version    : 0.1                                                          *
*  Date       : 16/Apr/2009                                                  *
*  Authors    : Alexandre Dias, Bruno Bastos                                 *
*               Humberto Carvalho, Leonardo Mangiapelo                       *
*               Renato Frias                                                 *
*                                                                            *
* -------------------------------------------------------------------------- *
* THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR        *
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES  *
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.    *
* IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,  *
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES         *
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR         *
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)         *
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,        * 
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING      *
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF             *
* THE POSSIBILITY OF SUCH DAMAGE.                                            *
* -------------------------------------------------------------------------- *
*  Description:                                                              *
* This software complements AN3815 - Implementing a Modular High Brightness  *
* RGB LED Network. The aim of the code is to proof the concept described on  *
* the application note document. It also serves as a starting point for      * 
* applications with MC56F8006 and some of its peripherals                    *
* -------------------------------------------------------------------------- *
*                                                                            *
*  File: sci.h	                                                             *
*                                                                            *
*    Header file for sci.c													 * 
*                                                                            *
******************************************************************************/

#ifndef _LIB_SCI_H
#define _LIB_SCI_H
 
/************************* Include Files *************************************/
              
#include "mc56f8006.h"

/********************************* Defines ***********************************/
#define BSP_OSCILLATOR_FREQ 			8000000L
#define PLL_MUL                         1L
#define PLL_POSTSCALER					(1<<0)	/* 1,2,4,8,16,32 */
#define SCI_CLOCK_HZ	(BSP_OSCILLATOR_FREQ * PLL_MUL / PLL_POSTSCALER / 2 )

//! SCI symbol for communication protocol start frame
#define SCI_START 		'@'
//! SCI symbol for communication protocol end frame
#define SCI_END 		'#'
//! SCI symbol for communication protocol Lit command
#define SCI_CMD_LIT 	'L'
//! SCI Rx buffer size
#define SCI_RX_BUFFER_SIZE 16
//! Used to set SCI baud rate to 115,200 bps
#define SCI_BAUDRATE_115k2 4400l
//! Used to set SCI baud rate to 6Mbps
#define SCI_BAUDRATE_6M 200000l
#define SCI_BAUDRATE_3M 100000l

/******************************** Prototypes *********************************/
extern void sci_init(uint32_t);
extern uint8_t sci_byte_received(void);
extern int8_t sci_read_byte(void);
extern void sci_isr(void);

#endif